import Image from "next/image";
import { memo } from "react";

const ProfileSection = memo(function ProfileSectionComponent({ profileInfo }) {
  return (
    <div className="flex flex-col gap-2 items-center">
      {profileInfo?.profilePicture?.url && (
        <Image
          className="w-24 h-24 rounded-full shadow-lg"
          src={profileInfo?.profilePicture?.url || ""}
          alt="Bonnie image"
          width={200}
          height={200}
          priority
        />
      )}
      <h3 className="text-xl font-medium text-gray-900 dark:text-white">
        {profileInfo?.name || ""}
      </h3>
      <span className="text-sm text-gray-500 dark:text-gray-400">
        {profileInfo?.bio || ""}
      </span>
    </div>
  );
});

export default ProfileSection;
